
unit WebForm7;

interface

uses
  System.Collections, System.ComponentModel,
  System.Data, System.Drawing, System.Web, System.Web.SessionState,
  System.Web.UI, System.Web.UI.WebControls, System.Web.UI.HtmlControls;

type
  TWebForm7 = class(System.Web.UI.Page)
  {$REGION 'Designer Managed Code'}
  strict private
    procedure InitializeComponent;
  {$ENDREGION}
  strict private
    procedure Page_Load(sender: System.Object; e: System.EventArgs);
  strict protected
		TopHolder: System.Web.UI.WebControls.PlaceHolder;
		CategoriesHolder: System.Web.UI.WebControls.PlaceHolder;
		topicHeading: System.Web.UI.WebControls.Label;
		topicDescription: System.Web.UI.WebControls.Label;
		ProdInCatHolder: System.Web.UI.WebControls.PlaceHolder;
    procedure OnInit(e: EventArgs); override;
  end;

implementation


uses catgrid, productsDB, top, apptypes;

var _top : CSTop;
    _AppTypes : csAppTypes;

procedure TWebForm7.Page_Load(sender: System.Object; e: System.EventArgs);
var
  product : TproductsDB;
  SearchAND : boolean;
  _CatGrid : TCatGrid;
begin
  		_CatGrid := TCatGrid.create;
    ProdInCatHolder.Controls.Add(_CatGrid);

    product:=TproductsDB.Create;

    topicHeading.Text:='Search results... ';

    //if not IsPostBack then
    begin
      topicDescription.Text:=Request.QueryString.Get('sterm');
      SearchAND := Request.QueryString.Get('sand')='1';
    end;

      try
        _CatGrid.DataSource := product.GetProductsFromSearch(topicDescription.Text, SearchAND);
        _CatGrid.DataBind;

        if (_CatGrid.DataSource as DataTable).Rows.Count = 0 then
          ProdInCatHolder.Controls.Add(LiteralControl.Create('No examples found that match the search criteria!'));

        if _CatGrid.PageCount = 1 then _CatGrid.PagerStyle.Visible := False;
      except on E:Exception do
        topicHeading.Text:='Search error!' + E.Message;
      end;



end;

procedure TWebForm7.OnInit(e: EventArgs);
begin
  //
  // CODEGEN: This call is required by the ASP.NET Web Form Designer.
  //
  InitializeComponent;
  inherited OnInit(e);

      _AppTypes := csAppTypes.create;
      CategoriesHolder.Controls.Add(_AppTypes);
      _AppTypes.Free;

      _top := CSTop.create;
      TopHolder.Controls.Add(_top);
      _top.Free;
end;

{$REGION 'Designer Managed Code'}
/// <summary>
/// Required method for Designer support - do not modify
/// the contents of this method with the code editor.
/// </summary>
procedure TWebForm7.InitializeComponent;
begin
	Include(Self.Load, Self.Page_Load);
end;
{$ENDREGION}


end.

